// Serveur web, écrit en node.js (associé à divers modules) pour le jeu du pendu

// Intégration des fichiers js complémentaires
var dico       = require('./lesMots.js');						// Tableau de plus de 50000 mots
// Variables globales provisoires pour la mise au point
var login = "invite";
var clef  = "06064a1f-e01e-4e0b-b0c0-e5541b74f45e";

// Intégration des modules
var express    = require('express');							// Framework express 4 de node.js
var morgan     = require('morgan');								// Système de log serveur
var bodyParser = require('body-parser');						// Plugin body-parser de express
var app        = express();										// Objet serveur

// Utilisation/activation des modules
//app.use(session({secret: 'ssshhhhh', resave: false, saveUninitialized: true}));
app.use( bodyParser.json() );									// Pour supporter les formats en JSON
app.use( bodyParser.urlencoded({extended: true}) );				// Pour supporter les URL avec paramètres
app.use( morgan('dev') );										// LOGs console de chaque requête http

app.use(function(req, res, next) {
	res.header("Access-Control-Allow-Origin", "*");
	res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
	next();
});

// Gestion des url et des requêtes
app.use(express.static(__dirname + '/public'));					// Gestion des pages statiques

// Définition des fonctions
function creerJeton(n, creer) {
}

function checkKey(name, key) {
}

function renvoyerUnMot(res) {
}

function repondreNonAuthentifie(res) {
}

function getJeu(req, res) {										// Réponse à la requête client en début du jeu
}

function proposerUnMot(req, res) {
}

function putPostJeu(req, res) {									// Réponse à la requête client en cours de jeu
}

app.get('/jeu/:invite/:clef', getJeu);							// Ecoute de la requête client GET à l'URI /jeu
app.put('/jeu/:invite/:clef', putPostJeu);						// Ecoute de la requête client PUT à l'URI /jeu
app.post('/jeu/:invite/:clef', putPostJeu);						// Ecoute de la requête client POST à l'URI /jeu

app.listen(80, function () {									// C'est le port par défaut en http
	console.log('Le serveur écoute sur le port 80');
});
