// Serveur web, écrit en node.js (associé à divers modules) pour le jeu du pendu
// Application des règles des API Web REST :
// Get / (fournit les fichiers : page statique, style, script et images)
//    => Page html statique index.html (autres fichiers : Get /img et Get /inc)
// Get /jeu : Début de la partie API et du jeu
//    => Tire au sort un mot, crée le jeton
//    => Renvoie { jeton: "1234567890", mot: "_ _ _ _ _ _ ", max: 14 }
// Post /jeu : Suite de la partie API et du jeu
//    => reçoit { jeton: "1234567890", lettres: "abci" }
//    => Renvoie { jeton: "1234567890", mot: "B _ A I _ _ ", lettres: "abci", echecs: 1, max: 14, gagne: false, true: false } 
// Installation des modules à partir de la console MsDOS (recherche en ligne sur les serveurs)
// npm install express,  npm install body-parser,  npm install morgan  et  npm install fs

// Définition d'une nouvelle méthode pour l'objet String
String.prototype.replaceAt = function(index, caractere) {
	return this.substr(0, index) + caractere + this.substr(index + 1);
}

// Intégration des fichiers js complémentaires
var dico       = require('./lesMots.js');						// Tableau de plus de 50000 mots

// Intégration des modules
var express    = require('express');							// Framework express 4 de node.js
var morgan     = require('morgan');								// Système de log serveur
var bodyParser = require('body-parser');						// Plugin body-parser de express
var app        = express();										// Objet serveur

// Utilisation/activation des modules
//app.use(session({secret: 'ssshhhhh', resave: false, saveUninitialized: true}));
app.use( bodyParser.json() );									// Pour supporter les formats en JSON
app.use( bodyParser.urlencoded({extended: true}) );				// Pour supporter les URL avec paramètres
app.use( morgan('dev') );										// LOGs console de chaque requête http

app.use(function(req, res, next) {
	res.header("Access-Control-Allow-Origin", "*");
	res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
	next();
});

// Gestion des url et des requêtes
app.use(express.static(__dirname + '/public'));					// Gestion des pages statiques

// Définition des fonctions
function creerJeton(n, creer) {
	if (creer) {
		var fin = Math.floor(1+Math.random()*9999)
		return 10000*(987654 - n) + fin;
	} else {
		return (987654 - Math.floor(n/10000));
	}
}

function checkKey(name, key) {
	var login = "invite";
	var clef  = "06064a1f-e01e-4e0b-b0c0-e5541b74f45e";
	return ((name == login) && (key == clef));
}

function renvoyerUnMot(res) {
	var n = Math.floor(Math.random()*dico.mots.length);			// Tirage au sort
	var jeton = creerJeton(n, true);							// Conception du code du jeton
	var motCache = dico.mots[n];								// Lecture du mot
	var rep    = {
		etat   : 1,
		jeton  : jeton,
		mot    : motCache.replace(/[a-z]/g,'_ '),
		max    : 14
	};
	console.log("Clé: "+jeton+" Mot choisi: "+motCache);		// Affichage mot sélectionné sur la console serveur
	console.log("format affiché: " + rep.mot + " nombre max d'essais: " + rep.max);	// Données envoyées
	res.send(200, rep);											// Envoi des données au client
}

function repondreNonAuthentifie(res) {
	var rep    = {
		etat   : 0,
		mess   : "Clé erronée"
	};
	res.send(401, rep);											// Envoi des données au client
}

function getJeu(req, res) {										// Réponse à la requête client en début du jeu
	console.log(req.params.invite, " ", req.params.clef); 
	if (checkKey(req.params.invite, req.params.clef))
		renvoyerUnMot(res);
	else
		repondreNonAuthentifie(res);							// Envoi code 401 au client
}

function proposerUnMot(req, res) {
	var motCache= dico.mots[creerJeton(+req.body.jeton, false)];
	var rep    = {
		status : 1,
		jeton  : req.body.jeton,
		mot    : motCache.replace(/[a-z]/g,'_ '),
		lettres: req.body.lettres,
		echecs : 0,
		max    : 14
	};

	var bonnes = 0;
	for (var i=0; i < rep.lettres.length; i++) {				// Analyse des essais
		var aucun = true;
		var lettre = rep.lettres[i].toLowerCase();
		while ((pos = motCache.indexOf(lettre)) >= 0) {
			motCache = motCache.replaceAt(pos, lettre.toUpperCase());
			rep.mot  = rep.mot.replaceAt(2*pos, lettre.toUpperCase());
			bonnes++;
			aucun = false;
		}
		if (aucun)
			rep.echecs++;
	}

	rep.gagne = (bonnes == motCache.length);
	rep.perdu = (rep.echecs >= rep.max);
	var mess = "Clé: "+rep.jeton+" Mot: "+rep.mot+" lettres: "+rep.lettres+" [ "+rep.echecs+" :-(  "+bonnes+" :-) ]";
	if (rep.gagne)
		mess += " gagné !";
	if (rep.perdu)
		mess += " perdu !";
	console.log(mess);
	res.send(201, rep);											// Envoi des données au client
}

function putPostJeu(req, res) {									// Réponse à la requête client en cours de jeu
	if (checkKey(req.params.invite, req.params.clef))
		proposerUnMot(req, res);
	else
		repondreNonAuthentifie(res);							// Envoi code 401 au client
}

app.get('/jeu/:invite/:clef', getJeu);							// Ecoute de la requête client GET à l'URI /jeu
app.put('/jeu/:invite/:clef', putPostJeu);						// Ecoute de la requête client PUT à l'URI /jeu
app.post('/jeu/:invite/:clef', putPostJeu);						// Ecoute de la requête client POST à l'URI /jeu

app.listen(80, function () {									// C'est le port par défaut en http
	console.log('Le serveur écoute sur le port 80');
});
