// Serveur web, écrit en node.js (associé à divers modules) pour le jeu du pendu
// Application des règles des API Web REST :
// Get / (fournit les fichiers : page statique, style, script et images)
//    => Page html statique index.html (autres fichiers : Get /img et Get /inc)
// Get /jeu : Début de la partie API et du jeu
//    => Tire au sort un mot, crée le jeton
//    => Renvoie { jeton: "1234567890", mot: "_ _ _ _ _ _ ", max: 14 }
// Post /jeu : Suite de la partie API et du jeu
//    => reçoit { jeton: "1234567890", lettres: "abci" }
//    => Renvoie { jeton: "1234567890", mot: "B _ A I _ _ ", lettres: "abci", echecs: 1, max: 14, gagne: false, true: false } 
// Installation des modules à partir de la console MsDOS (recherche en ligne sur les serveurs)
// npm install express,  npm install body-parser,  npm install morgan  et  npm install fs

// Définition d'une nouvelle méthode pour l'objet String
String.prototype.replaceAt = function(index, caractere) {
	return this.substr(0, index) + caractere + this.substr(index + 1);
}

// Intégration des fichiers js complémentaires
var bdd        = require('./sqlite.js');						// Gestion base de données
bdd.init();

// Intégration des modules
var express    = require('express');							// Framework express 4 de node.js
var morgan     = require('morgan');								// Système de log serveur
var bodyParser = require('body-parser');						// Plugin body-parser de express
var app        = express();										// Objet serveur

// Utilisation/activation des modules
app.use( bodyParser.json() );									// Pour supporter les formats en JSON
app.use( bodyParser.urlencoded({extended: true}) );				// Pour supporter les URL avec paramètres
app.use( morgan('dev') );										// LOGs console de chaque requête http

app.use(function(req, res, next) {
	res.header("Access-Control-Allow-Origin", "*");
	res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
	next();
});

// Gestion des url et des requêtes
app.use(express.static(__dirname + '/public'));					// Gestion des pages statiques

// Définition des fonctions
function creerJeton(n, creer) {
	if (creer) {
		var fin = Math.floor(1+Math.random()*9999)
		return 10000*(987654 - n) + fin;
	} else {
		return (987654 - Math.floor(n/10000));
	}
}

function renvoyerUnMotDb(res) {
	bdd.db.get("SELECT Count(*) FROM mots",function(err,rows){		// option possible : WHERE taille=6
		var r = Math.random();									// Tirage au sort
		var n = Math.floor(r*rows["Count(*)"]);					// Déduction du numéro dans le dictionnaire
		var jeton = creerJeton(n, true);						// Conception du code du jeton
		bdd.db.get("SELECT * FROM mots WHERE id=?", n, function(err, row) {
			var motCache = row.mot;								// Lecture du mot
			var rep    = {
				etat   : 1,
				jeton  : jeton,
				mot    : motCache.replace(/[a-z]/g,'_ '),
				max    : 14
			};
			console.log("CléDb: "+jeton+" Mot choisi: "+motCache);// Affichage mot sélectionné sur la console serveur
			console.log("format affiché: " + rep.mot + " nombre max d'essais: " + rep.max);	// Données envoyées
			res.send(200, rep);									// Envoi des données au client
		});
	});
}

function proposerUnMotDb(req, res) {
	var n = creerJeton(+req.body.jeton, false);
	bdd.db.get("SELECT * FROM mots WHERE id=?", n, function(err, row) {
		var motCache = row.mot;									// Lecture du mot
		var rep    = {
			status : 1,
			jeton  : req.body.jeton,
			mot    : motCache.replace(/[a-z]/g,'_ '),
			lettres: req.body.lettres,
			echecs : 0,
			max    : 14
		};

		var bonnes = 0;
		for (var i=0; i < rep.lettres.length; i++) {			// Analyse des essais
			var aucun = true;
			var lettre = rep.lettres[i].toLowerCase();
			while ((pos = motCache.indexOf(lettre)) >= 0) {
				motCache = motCache.replaceAt(pos, lettre.toUpperCase());
				rep.mot  = rep.mot.replaceAt(2*pos, lettre.toUpperCase());
				bonnes++;
				aucun = false;
			}
			if (aucun)
				rep.echecs++;
		}

		rep.gagne = (bonnes == motCache.length);
		rep.perdu = (rep.echecs >= rep.max);
		var mess = "Clé: "+rep.jeton+" Mot: "+rep.mot+" lettres: "+rep.lettres+" [ "+rep.echecs+" :-(  "+bonnes+" :-) ]";
		if (rep.gagne)
			mess += " gagné !";
		if (rep.perdu)
			mess += " perdu !";
		console.log("Db" + mess);
		res.send(201, rep);										// Envoi des données au client
	});
}

function repondreNonAuthentifie(res) {
	var rep    = {
		etat   : 0,
		mess   : "Clé erronée"
	};
	res.send(401, rep);											// Envoi des données au client
}

function getJeuDb(req, res) {									// Réponse à la requête client en début du jeu
	console.log(req.params.invite, " ", req.params.clef); 
	bdd.db.get("SELECT * FROM keys WHERE login=?", req.params.invite, function(err, row) {
		if (req.params.clef == row.key)
			renvoyerUnMotDb(res);
		else
			repondreNonAuthentifie(res);						// Envoi code 401 au client
	});
}

function putPostJeuDb(req, res) {								// Réponse à la requête client en cours de jeu
	bdd.db.get("SELECT * FROM keys WHERE login=?", req.params.invite, function(err, row) {
		if (req.params.clef == row.key)
			proposerUnMotDb(req, res);
		else
			repondreNonAuthentifie(res);						// Envoi code 401 au client
	});
}

app.get('/jeu/:invite/:clef', getJeuDb);						// Ecoute de la requête client GET à l'URI /jeu
app.put('/jeu/:invite/:clef', putPostJeuDb);					// Ecoute de la requête client PUT à l'URI /jeu
app.post('/jeu/:invite/:clef', putPostJeuDb);					// Ecoute de la requête client POST à l'URI /jeu

app.listen(80, function () {									// C'est le port par défaut en http
	console.log('Le serveur écoute sur le port 80');
});
