// Script du client du jeu du pendu lié à la page html.
// Ce jeu fonctionne en mode client - serveur web
// Le client n'a pas d'autre information sur le mot qu'un numéro et la taille du mot
// Le serveur renvoie le mot complété et le nombre d'essais infructueux
// Il détermine aussi si le joueur a gagné ou perdu

// Les variables globales mémorisant l'état du client
var jeton, motAffiche, lettres, gagne, perdu;
var site   = "http://127.0.0.1:8080";	// adresse absolue du site sur le serveur
var login  = "invite";
var clef   = "06064a1f-e01e-4e0b-b0c0-e5541b74f45e";

if (window.location.href.substring(0,4) != 'file')
	site   = "";					// Utiliser les adresses relatives si la page html est fournie par le serveur

// Fonction de gestion de l'affichage
function remplitLesChamps(info, style1, style2, echecs) {
	$( "#motAffiche" ).text(motAffiche);
	$( "#info" ).html(info).removeClass(style1).addClass(style2);
	var nbx = -180 * (echecs%4);
	var nby = -180 * Math.floor(echecs/4);
	$( "#cadreImage" ).css("background", "url(img/pendu_4x4.jpg) " + nbx + "px " + nby + "px")
}

function dessineClavier() {
	for (var i = 0; i < 26; i++) {
		if ([0, 20].reduce(function(acc, val) { return (acc || val == i); }, false))
			$("#clavier").append('<div class="espace"></div>');	// Centrage des premières et dernières lignes
		$("#clavier").append('<div class="lettre" id="code'+(i+65)+'">' + String.fromCharCode(i+65) + '</div>');
		if ([0, 4, 8, 14, 20, 24].reduce(function(acc, val) { return (acc || val == i); }, false))
			$("#code"+(i+65)).addClass("voyelle");	// Colorisation des voyelles
	}
}

// Requêtes serveur (attention : elles sont de type asynchrone)
function demanderUnMotAuServeur() { 	// Demander au serveur de choisir un mot au hasard
	$.ajax({
		type: 'GET',
		url : site + "/jeu/" + login + "/" + clef,
		success : function(data) {
			if (data.etat == 1) {
				// Initialisation partie contrôle
				jeton = data.jeton;
				motAffiche = data.mot;
				lettres = "";
				gagne = perdu = false;
				// Initialisation interface utilisateur
				remplitLesChamps("Vous avez droit à " + (data.max) + " essais au maximum", "topRight", "info", 0);
				$(".lettre").click(actionSiClick).removeClass("cache");
				$("#resultat").text("");
			} else $("#resultat").text("Erreur d'authentification");
		}
	}); // fin requête ajax get (début du jeu)
}

function proposerDesLettresAuServeur() { 	// Demander au serveur de faire évoluer l'état du client
	$.ajax({
		//type: 'PUT', // Au cas où on utilise PUT côté serveur également
		type: 'POST',
		url : site + "/jeu/" + login + "/" + clef,
		data: { jeton: jeton, lettres: lettres },
		dataType: 'json',
		success : function(data) {
			// Initialisation partie contrôle
			jeton = data.jeton;
			motAffiche = data.mot;
			gagne = data.gagne;
			perdu = data.perdu;
			// Initialisation interface utilisateur
			remplitLesChamps(data.echecs + '/' + (data.max), "info", "topRight", data.echecs);
			if (data.gagne)
				$("#resultat").text("Gagné !");
			else if (data.perdu)
				$("#resultat").text("Perdu !");
		}
	}); // fin requête ajax post (évolution du jeu)
}

// Action déclenchée au clic sur l'une des 26 lettres
function actionSiClick() {
	var lettre = $(this).text().trim().toLowerCase();
	if (!gagne && !perdu && lettres.indexOf(lettre) < 0) {
		$(this).addClass("cache").unbind();	// Cacher le bouton et le déconnecter de l'événement clic
		lettres = lettres + lettre; 		// Ajouter la lettre jouée à la liste
		proposerDesLettresAuServeur();		// Proposer la réponse au serveur 
	}
}

// Attente de la fin de la mise en place des éléments de la page
$(document).ready(function() {
	dessineClavier();
	demanderUnMotAuServeur();
	$("#rejouer").click(demanderUnMotAuServeur);
});
