#!/bin/env python3
import flask
# import hashlib
import random
import json

app = flask.Flask(__name__)

LESMOTS = []
KEY =  [82, 140, 9, 118, 48, 81, 7, 188, 146, 1, 212, 26, 93, 73, 144, 106, 13, 216, 32, 218]

ACCOUNTS = {"invite": "06064a1f-e01e-4e0b-b0c0-e5541b74f45e"}

def res_jeu(mot, lettres):
    print("RES : ", mot, lettres)
    mot = mot.upper()
    res = mot
    echecs = 0
    for l in lettres.upper():
        if l not in mot:
            echecs += 1
        else:
            res = res.replace(l, "*")
    res = list(res)
    for i, r in enumerate(res):
        if r == "*":
            res[i] = mot[i]
        else:
            res[i] = "_"
    return " ".join(res), echecs

def mot_to_jeton(mot):
    key = KEY[:]
    while len(key) < len(mot):
        key = key + key
    res = 0
    for m, k in zip(mot, key):
        res  = res * 256 + ord(m) ^ k
    return res

def jeton_to_mot(jeton):
    key = KEY[:]
    cryp = []
    while jeton > 0:
        cryp.append(jeton % 256)
        jeton = jeton // 256
    cryp.reverse()

    while len(key) < len(cryp):
        key = key + key
    res = []
    for m, k in zip(cryp, key):
        res.append(chr(m ^ k))
    return "".join(res)

def check_auth(login, key):
    if not login in ACCOUNTS or ACCOUNTS[login] != str(key):
        flask.abort(401)

# ===========================================================================
# Site  Web 
# ============================================================================

@app.errorhandler(404)
def error_404(e):
    stri = "Page not found"
    rep = flask.make_response(stri)
    rep.headers['Access-Control-Allow-Origin'] = '*'
    print(rep)
    print(dir(rep))
    return rep, 404

# =========================================================================================
# API WEB pour le CLIENT
# ==========================================================================================
# Access-Control-Allow-Origin
@app.after_request
def apply_caching(response):
    response.headers["Access-Control-Allow-Origin"] = "*"
    return response

@app.route('/jeu/<login>/<uuid:key>', methods=["GET"])
def jeu_get(login, key):
    check_auth(login, key)
    num = random.randint(0, len(LESMOTS) - 1)
    mot = " ".join("_"*len(LESMOTS[num]))
    print("===>", LESMOTS[num])
    return flask.jsonify({"etat": 1, "jeton": mot_to_jeton(LESMOTS[num]), "max": 14, "mot": mot})

@app.route('/jeu/<login>/<uuid:key>', methods=["POST"])
def jeu_post(login, key):
    check_auth(login, key)
    lettres = "".join(set(flask.request.form['lettres'].upper()))
    jeton = int(flask.request.form['jeton'])
    mot = jeton_to_mot(jeton)
    data = {"status": 1, "jeton": jeton, "lettres": lettres, "max": 14}
    data["mot"], data["echecs"] = res_jeu(mot, lettres)
    data["gagne"] = "_" not in data["mot"]
    data["perdu"] = (data["max"] == data["echecs"])
    print(data)
    return flask.jsonify(data)

# ==========================================================================================
# MAIN
# ==========================================================================================
app.secret_key = 'A0Zr98j/3yX R~XHH!sqdlqmezaeajmN]LWX/,?RT'
print("PATH =====>", app.instance_path)
if __name__ == '__main__':
    with open("mots.txt","r") as f:
        for mot in f.readlines():
           LESMOTS.append(mot.strip())
    app.config['DEBUG'] = True
    app.run(host='0.0.0.0', port=5000)
