import tkinter as tk
import tkinter.font
from functools import partial
import random
import urllib.request
import json

NOTICE = """\
Origine du jeu :Inconnue.

But : Trouver le mot le plus rapidement possible.

Le dessin terminé représente généralement un bonhomme allumette qui se pend.\
"""

SERVER = "http://localhost:5000"
LOGIN = "invite"
KEY = "06064a1f-e01e-4e0b-b0c0-e5541b74f45e"

def letter_pos(letter, word):
    """ Renvoie les indices des occurences de letter dans word """
    res = []
    for i, l in enumerate(word):
        if letter == l:
            res.append(i)
    return res


class Pendu(tk.Canvas):
    """ Affichage de l'image du pendu"""

    def __init__(self, parent, width, height, bg=None):
        super().__init__(parent, width=width, height=height, bg=bg)
        self.value = 0
        self.image = tk.PhotoImage(file="pendu4x4.gif")  # Ref permanente !
        # self.image = ImageTk.PhotoImage(file="pendu4x4.jpg") # Ref permanente !
        self.imgpos = self.create_image(0, 0, image=self.image, anchor=tk.NW)
        # self.reinit()

    def reinit(self):
        self.value = 0
        self.update_img_()

    def next_img(self):
        if self.value >= 15:
            return False
        self.value += 1
        self.update_img_()
        return self.value < 15

    def set_img(self, num):
        self.value = num
        self.update_img_()

    def update_img_(self):
        i, j = divmod(self.value, 4)
        self.coords(self.imgpos, -j * 180, -i * 180)


class Fenetre(tk.Frame):
    def __init__(self, root):
        self.dicolettres = {}  # Refs vers les boutons lettres
        self.reponse = None  # Champ d'affichage du mot trouvé
        self.propositions = set()  # Lettre proposées dans la partie
        self.numword = None  # Numéro du Mot à trouver
        self.dpendu = None  # Widget dessin de pendu
        self.partie_en_cours = False  # Ne prend plus les clics lettre si False

        super().__init__(root)

        root.title("jeu de Pendu")
        self.pack(fill=tk.BOTH, expand=1)

        # Titre
        label = tk.Label(self, text="Jeu de Pendu", fg="blue", bg="yellow", pady=10,
                         font=tkinter.font.Font(family='Helvetica', size=36, weight='bold'))
        label.pack(side=tk.TOP, fill=tk.X)
        # Frame inférieure
        middle = tk.Frame(self)
        middle.pack(fill=tk.BOTH, expand=1)
        # Zone de gauche
        self.dpendu = Pendu(middle, width=180, height=180)
        self.dpendu.pack(side=tk.LEFT)
        # Zone centrale
        clavier = tk.Frame(middle)
        self.lettres(clavier)
        clavier.pack(side=tk.LEFT, fill=tk.BOTH, expand=1)
        # Zone de droite
        notice = tk.Label(middle, text=NOTICE, wraplength=200, padx=5, pady=6)
        notice.pack(side=tk.RIGHT)

    def lettres(self, clavier):
        """ Création des boutons alphabet et du bouton jouer
            et du champs réponse
        """
        size = 20  # Taille des boutons lettres
        for k, lettre in enumerate("ABCDEFGHIJKLMNOPQRSTUVWXYZ"):
            i, j = divmod(k, 7)
            bouton = tk.Button(clavier, text=lettre, state=tk.DISABLED, width=2, height=2,
                               command=partial(self.clic_lettre, lettre))
            bouton.grid(row=i, column=j)
            self.dicolettres[lettre] = bouton
        bouton = tk.Button(clavier, text="Jouer", height=2, width=6, command=self.newgame)
        bouton.grid(row=3, column=5, columnspan=2)
        for voy in "AEIOUY":
            self.dicolettres[voy].config(fg="red")
        self.reponse = tk.Label(clavier, text="", bg="white",
                                font=tkinter.font.Font(family='Helvetica', size=15, weight='bold'))
        self.reponse.grid(row=4, column=0, columnspan=7)

    def newgame(self):
        """ Callback nouvelle partie : choix d'un mot, remise en état de l'interface"""
        rep = urllib.request.urlopen(SERVER + "/jeu/{}/{}".format(LOGIN, KEY)).read()
        data = json.loads(rep.decode("utf8"))
        print("====> ", data)
        self.jeton = data["jeton"]
        self.reponse["text"] = data["mot"]
        self.propositions = set()
        self.reinit_buttons()
        self.dpendu.reinit()
        self.partie_en_cours = True

    def reinit_buttons(self):
        """ Remet tous les boutons lettre en état pour un
            début de partie
        """
        for lettre in self.dicolettres.values():
            lettre.config(state=tk.NORMAL, bg="gray")

    def clic_lettre(self, lettre):
        """ Callback clic sur une lettre """
        if not self.partie_en_cours:
            return
        if lettre in self.propositions:  # Ça ne devrait pas arriver...
            return
        self.propositions.add(lettre)
        self.dicolettres[lettre].config(state=tk.DISABLED, bg="black")
        # Proposition de la lettre au serveur :
        data = urllib.parse.urlencode({"jeton": self.jeton, "lettres": "".join(self.propositions)}).encode("utf8")
        rep = urllib.request.urlopen(SERVER + "/jeu/{}/{}".format(LOGIN, KEY), data=data).read().decode("utf8")
        res = json.loads(rep)

        self.reponse["text"] = res["mot"]
        self.dpendu.set_img(res["echecs"])
        if res["gagne"]:
            self.partie_en_cours = False
            self.reponse["text"] = self.reponse["text"] + "\nGAGNÉ !"
        if res["perdu"]:
            self.partie_en_cours = False
            self.reponse["text"] = self.reponse["text"] + "\nPERDU !"


def main():
    root = tk.Tk()
    gui = Fenetre(root)
    root.mainloop()


if __name__ == "__main__":
    main()
