"use strict";
var ctx, w, h; // Variables liées au canvas (contexte, largeur et hauteur)

function dimensionneLeCanvas() { // Détermine largeur et hauteur du canvas en fonction de la taille de la fenêtre
	ctx = $("#zoneGraphe")[0].getContext("2d");
	w = $(window).width() - 2*15;
	h = $(window).height() - $("#connexion").outerHeight() - $("#status").outerHeight()- 30;
	$("#zoneGraphe").attr("width", w);
	$("#zoneGraphe").attr("height", h);
}

function remplitLesChampsHTML() { // Provisoirement, pour simplifier, les paramètres de connexion sont préremplis
	$("input[name='serveur']").val(site);
	$("input[name='login']").val(login);
	$("input[name='clef']").val(clef);
	$("#status").attr("width", w).html("status");
}

function dessinerUnNoeud(x, y, rayon, poids, color) {
	ctx.beginPath();
	ctx.arc(x, y, rayon, 0, 2*Math.PI, false);
	ctx.fillStyle = color;
	ctx.fill();
	ctx.lineWidth = 1;
	ctx.strokeStyle = 'blue';
	ctx.font = "bold " + 1.5*rayon + "px serif";
	ctx.fillStyle = 'white';
	ctx.textBaseline = "middle";
	ctx.fillText(poids, x - ctx.measureText(poids).width/2, y);
	ctx.stroke();
}

function dessineUneArete(x1, y1, x2, y2) { // Trace les droites correspondant aux liens entre les noeuds
	ctx.beginPath();
	ctx.lineWidth = 1;
	ctx.strokeStyle = 'red';
	ctx.moveTo(x1, y1);
	ctx.lineTo(x2, y2);
	ctx.stroke();
}

function dessineLeGraphe() { // Dessine tout le graphe (arêtes puis noeuds)
	ctx.clearRect(0, 0, w, h);
	for (var coord of graphe.graph_edges) {
		if (noeuds.hasOwnProperty(coord[0]) && noeuds.hasOwnProperty(coord[1]))
			dessineUneArete(noeuds[coord[0]].x, noeuds[coord[0]].y, noeuds[coord[1]].x, noeuds[coord[1]].y);
	}
	for (var key in noeuds) {
		noeuds[key].dessine();
	}
}

