"use strict";

// Portions des URI pour accéder aux ressources du serveur
var site    = "http://lsignac.pythonanywhere.com";
var login   = "invite";
var clef    = "06064a1f-e01e-4e0b-b0c0-e5541b74f45e";
var pathGet = "/get_game/";
var pathPost= "/post_game/";

// Déclaration des variables globales
var cpt, pos;
var graphe  = {}, noeuds = {}, partie = {}; 	// Tableaux associatifs pour les données de départ, la visualisation et le jeu

// Définition des fonctions
function lectureDuGraphe(data) { // Initialisation, nombre de noeuds, présence des positions
	graphe = data; //JSON.parse(data); // si dataType: 'html',
	cpt = Object.keys(graphe.values).length;
	pos = graphe.hasOwnProperty('positions');
	partie.name = graphe.name;
	partie.game = [];
	noeuds = {};
}

function xn(key) { // Retourne l'abscisse du noeud, soit imposée, soit calculée
	if (pos && graphe.positions.hasOwnProperty(key))
		return w/2 - 0.8*w/2*graphe.positions[key][0];
	else 
		return w/2 - 0.8*w/2*Math.sin(i*2*Math.PI/cpt);
}

function yn(key) { // Retourne l'ordonnée du noeud, soit imposée, soit calculée 
	if (pos && graphe.positions.hasOwnProperty(key))
		return h/2 - 0.8*h/2*graphe.positions[key][1];
	else
		return h/2 - 0.8*h/2*Math.cos(i*2*Math.PI/cpt);
}

function NoeudSousLaSouris(xMouse, yMouse) { // Nettoyer le noeud du graphe et ses voisins
	var ok = false;
	for (var key in noeuds) {
		if ((Math.abs(xMouse - noeuds[key].x) < noeuds[key].r) && (Math.abs(yMouse - noeuds[key].y) < noeuds[key].r)) {
			ok = true;
			partie.game.push(noeuds[key].nom);
			delete noeuds[key];
			for (var coord of graphe.graph_edges) {
				if ((coord[0] == key) && noeuds.hasOwnProperty(coord[1]))
					delete noeuds[coord[1]];
				if ((coord[1] == key) && noeuds.hasOwnProperty(coord[0]))
					delete noeuds[coord[0]];
			} // fin de for of graphe
			break; // sortie de for in noeuds
		} // fin if
	} // fin for in noeuds
	return ok;
}

function nettoyerLeGraphe(xMouse, yMouse) { // Nettoyer le noeud du graphe et ses voisins
	if (NoeudSousLaSouris(xMouse, yMouse)) {
		if (Object.keys(noeuds).length > 0)
			dessineLeGraphe();
		else {
			ctx.clearRect(0, 0, w, h);
			informerLeServeur();
		}
	}
}

function lireLeServeur() { // S'authentifier et lire le graphe proposé par le serveur
	site  = $("input[name='serveur']").val();
	login = $("input[name='login']").val();
	clef  = $("input[name='clef']").val();
	$.ajax({
		url : site + pathGet + login + "/" + clef,
		type: 'GET',
		dataType: 'json', //si 'html', il faut utiliser JSON.parse(data)
		success : function(data) {
			lectureDuGraphe(data);
			$("title").html(graphe.name);
			$("#status").html(graphe.name);
			ctx.clearRect(0, 0, w, h);
		},
		error : function(data) {
			$("#status").html(data.message);
		}
	}); // fin requête Get ajax
}

function informerLeServeur() { // S'authentifier et donner au serveur le nom du graphe et la liste des noeuds supprimés
	var query = {name : partie.name, game: JSON.stringify(partie.game)}; // ADAPTATION au format attendu par le serveur
	console.log(partie, query);
	$.ajax({
		url : site + pathPost + login + "/" + clef,
		type: 'POST',
		data : query,
		dataType: 'json',
		success : function(data) {
			$("#status").html(data.message);
		},
		error : function(data) {
			$("#status").html(data.message);
		}
	}); // fin requête Post ajax
}

// *** Début du script maître ***
$(document).ready(function() {
	dimensionneLeCanvas();
	remplitLesChampsHTML();

	// Evénements associés aux boutons
	$("#connecter").click(lireLeServeur); // Lecture du graphe sur le serveur
	$("#partie").click(function() { // Analyse du graphe reçu et dessin du graphe
		creerUnNoeud();
		dessineLeGraphe();
	});

	// Evénements souris dans le canvas
	$("#zoneGraphe").mousemove(function(evenement) { // Clic gauche
		var parentOffset = $(this).offset(); 
		deplacerUnNoeud(evenement, evenement.pageX - parentOffset.left, evenement.pageY - parentOffset.top)
	});
	$("#zoneGraphe").contextmenu(function(evenement) { // Clic droit
		evenement.preventDefault();
		var parentOffset = $(this).offset(); 
		nettoyerLeGraphe(evenement.pageX - parentOffset.left, evenement.pageY - parentOffset.top);
	});


}); 
