import bdd
import flask
import graphe
from uuid import uuid4
import int_graphs

# Code écrit par Laurent Signac / Janvier 2017

GAMES = {}

def create_games():
    for name in dir(int_graphs):
        if name.startswith("gr"):
            game = graphe.Graphe(getattr(int_graphs, name)[0], getattr(int_graphs, name)[1])
            GAMES[name] = {'name': name, 'graph': game}
            if len(getattr(int_graphs, name)) >= 3:
                GAMES[name]['positions'] = getattr(int_graphs, name)[2].copy()

    print("Succcessfully created {} games".format(len(GAMES)))
    print(GAMES.keys())


# UTILITAIRES
# ========================================================================================
def check_key(login, key):
    """ Vérifie que la clé est bien associée au login
        renvoie True ou False
    """
    offkey = bdd.get_key(login)
    print("=====>", offkey)
    return offkey == str(key)


def check_login():
    """ Vérifie si on est logué,
        Forbidden si ce n'est pas le cas
    """
    if 'username' in flask.session:
        return flask.escape(flask.session['username'])
    flask.abort(403)


def simulate_game(graph_name, game):
    """ Simule une partie pour un graphe donné.
        Si la partie est correcte, renvoie le score
        Si la partie est incorrecte, renvoie None
    """

    # Attention, ici, il faut des copies, sinon
    # on décime les graphes de la structure GAMES !!!
    graph = GAMES[graph_name]['graph'].copy()
    score = 0

    for p in game:
        if p not in graph:
            return None
        score += graph[p]
        graph.deep_remove(p)
    if len(graph) > 0:
        return None
    rec_score = round(2000 / (score + 1), 2)
    return rec_score

def store_new_key(login):
    """ Choisit une nouvelle clé appli pour login, la stocke dans la bdd et
        la renvoie
    """
    key = str(uuid4())
    bdd.set_new_key(login, key)
    return key
