import random
import json
import flask
import bdd
import server_common as common
restapi = flask.Blueprint('restapi', __name__)

# Code écrit par Laurent Signac / Janvier 2017

# =========================================================================================
# API WEB pour le CLIENT
# ==========================================================================================
# Access-Control-Allow-Origin
# Pb CORS constaté avec client Javascript  : https://en.wikipedia.org/wiki/Cross-origin_resource_sharing
@restapi.after_request
def apply_caching(response):
    response.headers["Access-Control-Allow-Origin"] = "*"
    return response

# On passe login et password (haché) en post, et
# ça renvoie une clé de ssession (format uuid)
#@restapi.route('/newkey', methods=['POST'])
#def new_key():
#    login = flask.request.form['login']
#    hashpassword = flask.request.form['password']
#    if not bdd.check_account(login, hashpassword):
#        return flask.jsonify({"status": 0, "message": "Login/Pass erroné"})
#    key = common.store_new_key(login)
#    return flask.jsonify({"status": 1, "message": key})

# On donne login et clé de session
# La fonction renvoie un jeu choisi au hasard dans la liste
@restapi.route('/get_game/<login>/<uuid:key>')
def get_game(login, key):
    if not common.check_key(login, key):
        return flask.jsonify({"status": 0, "message": "Cle erronee"})
    graph = random.choice(list(common.GAMES.keys()))

    return get_this_game(login, key, graph)


# On donne login et clé de session
# La fonction renvoie le jeu choisi
@restapi.route('/get_this_game/<login>/<uuid:key>/<game>')
def get_this_game(login, key, game):
    if not common.check_key(login, key):
        return flask.jsonify({"status": 0, "message": "Cle erronee"})

    if game not in common.GAMES:
        return flask.jsonify({"status": 0, "message": "Jeu inconnu"})

    #graph = common.GAMES[game].copy()
    #graph.update({'status': 1})  # Ça c'est bien pourri...
    #jsongraph = json.dumps(graph, default=graphe.to_json)

    data = {'status': 1, 'name': game,
            'values': dict(common.GAMES[game]['graph'].iter_values()),
            'graph_edges': list(common.GAMES[game]['graph'].iter_edges()) # [list(_) for _ in common.GAMES[game]['graph'].iter_edges()]
           }
    if 'positions' in common.GAMES[game]:
        data['positions'] = common.GAMES[game]['positions']
    print("SENDING", data)

    # Ceci est à améliorer, probablement en customisant
    # la fonction flask.jsonify, qui opère à plus haut niveau
    # return flask.jsonify(data)
    return flask.Response(response=json.dumps(data),
                          status=200,
                          mimetype="application/json")


# On donne login et clé de session
# On passe en post le nom du graphe et la partie jouée (liste des
# noeuds cliqués).
# La fonction vérifie la partie et enregistre le  score
@restapi.route('/post_game/<login>/<uuid:key>', methods=['POST'])
def post_game(login, key):
    if not common.check_key(login, key):
        return flask.jsonify({"status": 0, "message": "Cle erronee"})

    # Récupère les données en Json
    if flask.request.headers.get('Content-Type') == 'application/json':
        content = flask.request.get_json()
        name = content['name']
        game = content['game']
    # Ou bien urlencoded
    else:
        name = flask.request.form['name']
        game = json.loads(flask.request.form['game'])
    res = common.simulate_game(name, game)
    if res is None:
        return flask.jsonify({'status': 0, 'message': 'Solution invalide'})
    else:
        result = bdd.set_score(login, name, res)
        if result:
            return flask.jsonify(
                {'status': 1, 'message': 'Solution valide : {} pts. C\'est votre meilleur score'.format(res)})
        else:
            return flask.jsonify({'status': 1,
                                  'message': 'Solution valide : {:.3f} pts. Vous avez déjà fait aussi bien (ou mieux)'.format(res)})
