""" Gestion de la base de données : comptes, scores, etc...
    Toutes les opérations en relation avec la bdd sont faites ici
"""
# Code écrit par Laurent Sgnac - Janvier 2017
import sqlite3
import hashlib
import traceback
import sys

_FILENAME = None

# Ces deux fonctions se connectent à la base exécutent une requete 
# (select ou autre) et se déconnectent

def _select(req, params):
    with sqlite3.connect(_FILENAME) as conn:
        conn.row_factory = sqlite3.Row
        c= conn.cursor()
        c.execute(req, params)
        result = c.fetchall()
    return [dict(_) for _ in result]

def _requete(req, params):
    success = True
    with sqlite3.connect(_FILENAME) as conn:
        c= conn.cursor()
        try:
            c.execute(req, params)
            conn.commit()
        except :
            print("ERREUR DANS REQUETE")
            traceback.print_exc(file=sys.stdout)
            success = False
    return success

# Création de la base 
def _create_db():
    with sqlite3.connect(_FILENAME) as conn:
        c= conn.cursor()
        c.execute("CREATE TABLE if not exists keys(login text primary key, key text);")
        c.execute("CREATE TABLE if not exists scores(login text, graph_name text, score real, PRIMARY KEY(login, graph_name));")
        c.execute("CREATE TABLE if not exists accounts(login text primary key, password text)")
        conn.commit()
    return 
    
def set_new_key(login, key):
    """ Modifie la clé de connexion pour l'utilisateur """
    _requete('insert or replace into keys values (?, ?)', (login, key))

def get_key(login):
    """ Renvoie la clé de l'utilisateur """
    result = _select('select key from keys where login=?', (login,))
    if len(result) != 1:
        return None
    return result[0]["key"]

def set_score(login, graph_name, score):
    """ Enregistre un score, s'il est meilleur que le high score pour ce graphe. 
        Renvoie True dans ce cas.
    """
    res = _select('select score from scores where login=? and graph_name=?', (login, graph_name))
    if len(res) == 0 or score > res[0]["score"]:
        _requete('insert or replace into scores values(?, ?, ?)', (login, graph_name, score))
        return True
    return False

def get_score(login, graph_name):
    """ Renvoie le score obtenu pour ce graphe, ou None s'il n'y en a pas.
    """
    res = _select('select score from scores where login=? and graph_name=?', (login, graph_name))
    if len(res) == 0:
        return None
    return res[0]["score"]

def get_scores_graph(graph_name):
    """ Renvoie le hall of fame pour ce graphe.
    """
    res = _select('select login, score from scores where graph_name=?', (graph_name,))
    #if len(res) == 0:
    #    []
    return [(result["login"], result["score"]) for result in res]
    
    
def new_account(login, hashpasswd):
    """ Ajoute un nouveau compte
    """
    return  _requete("insert into accounts values(?,?)", (login, hashpasswd))
    
    
def check_account(login, hashpasswd):
    """ 
        Vérifie un couple login mdp (haché)
    """
    res = _select("select * from accounts where login=? and password=?", (login, hashpasswd))
    return len(res) == 1
    
    
def create_db(filename):
    global _FILENAME
    _FILENAME = filename
    _create_db()
