// Exemple de serveur web RESTFull
// Get /             : Affiche la page html statique
// Get /mots         : Renvoie la liste des mots
// Get /mots/count   : Renvoie le nombre de mots
// Post /mots/creer  : Ajoute un mot
// Put /mot/:id      : Modifie le mot désigné par son numéro
// Get /mot/:id      : Renvoie le mot désigné par son numéro
// Delete /mot/:id   : Supprime le mot désigné par son numéro

// Intégration des fichiers js complémentaires
var les        = require('./qqMots.js');			// Importer un tableau de quelques mots

// Intégration des modules de node.js
var express    = require('express');				// Framework express 4 de node.js
var bodyParser = require('body-parser');			// Plugin body-parser de express
var morgan     = require('morgan');					// Système de log serveur
var app        = express();							// Objet serveur

// Utilisation/activation des modules
app.use( bodyParser.json() );						// Pour supporter les formats en JSON
app.use( bodyParser.urlencoded({extended: true}) );	// Pour supporter les URL avec paramètres
app.use( morgan('dev') );							// LOGs console de chaque requête http

app.use(function(req, res, next) {
	res.header("Access-Control-Allow-Origin", "*");
	res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
	next();
});

// Fonctions liées aux 4 verbes GET, POST, PUT et DELETE
function renvoieListe(request, result) {			// Réponse à la requête GET /mots
	console.log("Tableau de", les.qqMots.length, "mots renvoyé");
	result.send(200, { mots : les.qqMots });		// Données envoyées avec le status OK
}

function renvoieTotal(request, result) {			// Réponse à la requête GET /mots/count
	var total = les.qqMots.length;
	console.log("Nombre de mots", les.qqMots.length);
	result.send(200,{ total : les.qqMots.length });	// Données envoyées avec le status OK
}

function ajouteMot(request, result) {				// Réponse à la requête POST /mots/creer
	var mot = request.body.mot;						// Récupérer le paramètre mot des données
	les.qqMots.push(mot);							// Ajoute le mot en fin de tableau
	var id = les.qqMots.length-1;
	console.log("Mot", mot, "ajouté au rang", id);
	result.send(201, {id : id, mot : mot});			// Envoi au client du status 201 Created
}

function majMot(request, result) {					// Réponse à la requête PUT /mot/...
	var id  = request.params.id;					// Récupérer le paramètre id contenu dans l'URI
	var mot = request.body.mot;						// Récupérer le paramètre mot des données
	if (les.qqMots[id]) {
		les.qqMots[id] = mot;						// Modifie le mot dans le tableau
		console.log("Mot n°", id, "(", les.qqMots[id], ") remplacé par", mot);
		result.send(200, {id : id, mot : mot});		// Envoi au client du status OK
	} else {
		console.log("Le mot n°", id, "n'existe pas");
		result.send(400);							// Code d'erreur 400 : Mauvaise requête
	}
}

function renvoieMot(request, result) {				// Réponse à la requête GET /mot/...
	var id  = request.params.id; 					// Récupérer le paramètre id dans l'URI
	var mot = les.qqMots[id];
	if (mot) {
		console.log("Mot n°", id, "(", mot, ") envoyé");
		result.send(200, {id : id, mot : mot});		// Données envoyées avec status OK
	} else {
		console.log("Le mot n°", id, "n'existe pas");
		result.send(400);							// Code d'erreur 400 : Mauvaise requête
	}
}

function supprimeMot(request, result) {				// Réponse à la requête DELETE /mot/...
	var id  = request.params.id;					// Récupérer le paramètre id dans l'URI
	var mot = les.qqMots[id];
	if (mot) {
		les.qqMots.splice(id, 1);					// Supprime le mot dans le tableau
		console.log("Mot n°", id, "(", mot, ") supprimé");
		result.send(204);							// Code d'erreur 204 : No Content !
	} else {
		console.log("Le mot n°", id, "n'existe pas");
		result.send(400);							// Code d'erreur 400 : Mauvaise requête
	}
}

app.get('/mots', renvoieListe);						// Requête GET    à l'URI /mots
app.get('/mots/count', renvoieTotal);				// Requête GET    à l'URI /mots/count
app.post('/mots/creer', ajouteMot);					// Requête POST   à l'URI /mots/creer
app.put('/mot/:id', majMot);						// Requête PUT    à l'URI /mot/...
app.get('/mot/:id', renvoieMot);					// Requête GET    à l'URI /mot/...
app.delete('/mot/:id', supprimeMot);				// Requête DELETE à l'URI /mot/...
app.listen(81, function () {						// C'est le second port http
	console.log('Le serveur écoute sur le port 81');
});
