#!/bin/env python3

# Exemple de serveur web RESTFull
# Get /             : Affiche la page html statique
# Get /mots         : Renvoie la liste des mots
# Get /mots/count   : Renvoie le nombre de mots
# Post /mots/creer  : Ajoute un mot
# Put /mot/:id      : Modifie le mot désigné par son numéro
# Get /mot/:id      : Renvoie le mot désigné par son numéro
# Delete /mot/:id   : Supprime le mot désigné par son numéro

import flask
import hashlib
import random
import json
import requests    

app = flask.Flask(__name__)

LESMOTS = []

# ============================================================================
# API WEB pour le CLIENT
# ============================================================================
# Access-Control-Allow-Origin
@app.after_request
def apply_caching(response):
    response.headers["Access-Control-Allow-Origin"] = "*"
    return response

# Gestion des routes
@app.route('/mots', methods=["GET"])
def renvoieListe():
    print("Tableau de", len(LESMOTS), "mots renvoyé")
    return flask.jsonify({"mots": LESMOTS})

@app.route('/mots/count', methods=["GET"])
def renvoieTotal():
    print("Nombre de mots", len(LESMOTS))
    return flask.jsonify({"total": len(LESMOTS)})

@app.route('/mot/<id>', methods=["GET"])
def renvoieMot(id):
    uid = int(id)
    mot = LESMOTS[uid]
    print("Mot n°", uid, "(", mot, ") envoyé")
    return flask.jsonify({"id": uid, "mot": LESMOTS[uid]})

@app.route('/mot/<id>', methods=["DELETE"])
def supprimeMot(id):
    uid = int(id)
    del LESMOTS[uid]
    print("Mot n°", uid, "supprimé")
    return flask.jsonify({"id": uid})

@app.route('/mot/<id>', methods=["PUT"])
def majMot(id):
    uid = int(id)
    content = flask.request.get_json()
    mot = content["mot"]
    if uid < len(LESMOTS):
        LESMOTS[uid] = mot
        print("Mot n°", uid, "(", LESMOTS[uid], ") remplacé")
        return flask.jsonify({"id": uid})
    else:
        return flask.abort(400)

@app.route('/mots/creer', methods=["POST"])
def ajouteMot():
    content = flask.request.get_json()
    mot = content["mot"]
    LESMOTS.append(mot)
    id = len(LESMOTS)-1
    print("Mot", mot, "ajouté au rang", id)
    return flask.jsonify({"id": id, "mot": mot})

# ============================================================================
# MAIN
# ============================================================================
print("PATH =====>", app.instance_path)
if __name__ == '__main__':
    with open("mots.txt","r") as f:
        for mot in f.readlines():
           LESMOTS.append(mot.strip())
    app.config['DEBUG'] = True
    app.run(host='0.0.0.0', port=8080)
