// Script du client du serveur RESTFull.
var site   = ""; // mettre http://127.0.0.1 si la page html est lancée localement

function demanderListe() {
	var url = site + "/mots";
	$.ajax({
		type: 'GET',
		url : url,
		success : function(data) {
			$("#requete").html("GET : " + url);
			$("#reponse").html(JSON.stringify(data));
			$("#resultat").html("");
			for (var key in data.mots)
				$("#resultat").append("<div class='rep'>"+key+":"+data.mots[key]+"</div>");
		}
	});
}
function demanderTotal() {
	var url = site + "/mots/count";
	$.ajax({
		type: 'GET',
		url : url,
		success : function(data) {
			$("#requete").html("GET : " + url);
			$("#reponse").html(JSON.stringify(data));
			$("#resultat").html("<div class='rep'>Nombre total de mots : "+data.total+"</div>");
		}
	});
}
function ajouterMot() {
	var url = site + "/mots/creer";
	var requete = { mot: $("#mot").val() || "oubli ;-))"};
	$.ajax({
		type: 'POST',
		url : url,
		data: requete,
		dataType: 'json',
		success : function(data) {
			$("#requete").html("POST : " + url + "<br/>" + JSON.stringify(requete));
			$("#reponse").html(JSON.stringify(data));
			$("#resultat").html("<div class='rep'>Mot "+data.mot+" ajouté à la position : "+data.id+"</div>");
		}
	});
}
function modifierMot() {
	var id = $("#id").val();
	var url = site + "/mot/" + id;
	var requete = { mot: $("#mot").val() || "oubli ;-))" };
	$("#requete").html("PUT : " + url + "<br/>" + JSON.stringify(requete));
	$("#resultat").html("");
	$.ajax({
		type: 'PUT',
		url : url,
		data: requete,
		dataType: 'json',
		success : function(data) {
			$("#reponse").html(JSON.stringify(data));
			$("#resultat").html("<div class='rep'>Mot n° "+data.id+" remplacé par :"+data.mot+"</div>");
		},
		statusCode: {
			400: function() { $("#reponse").html("Code 400 : Le mot n'existe pas"); },
			404: function() { $("#reponse").html("Code 404 : La ressource n'existe pas"); }
		}
	});
}
function demanderMot() {
	var id = $("#id").val();
	var url = site + "/mot/" + id;
	$("#requete").html("GET : " + url);
	$("#resultat").html("");
	$.ajax({
		type: 'GET',
		url : url,
		success : function(data) {
			$("#reponse").html(JSON.stringify(data));
			$("#resultat").html("<div class='rep'>Mot n° " + data.id + " : " + data.mot + "</div>");
		},
		statusCode: {
			400: function() { $("#reponse").html("Code 400 : Le mot n'existe pas"); },
			404: function() { $("#reponse").html("Code 404 : La ressource n'existe pas"); }
		}
	});
}
function supprimerMot() {
	var id = $("#id").val();
	var url = site + "/mot/" + id;
	$("#requete").html("DELETE : " + url);
	$("#resultat").html("");
	$.ajax({
		type: 'DELETE',
		url : url,
		success : function(data) {
			$("#reponse").html("");
			$("#resultat").html("<div class='rep'>Mot n°" + id + " : supprimé </div>");
		},
		statusCode: {
			400: function() { $("#reponse").html("Code 400 : Le mot n'existe pas"); },
			404: function() { $("#reponse").html("Code 404 : La ressource n'existe pas"); }
		}
	});
}

$(document).ready(function() {
	$("#getListe").click(demanderListe);
	$("#getTotal").click(demanderTotal);
	$("#ajoutMot").click(ajouterMot);
	$("#putMot").click(modifierMot);
	$("#getMot").click(demanderMot);
	$("#delMot").click(supprimerMot);
});
